package com.genesyslab.samples.interceptor;

import java.util.Map;

import com.genesyslab.ail.InteractionMultimedia;
import com.genesyslab.ail.exception.RequestFailedException;

/**
 * This class is used to implement the behavior that must be executed when a agent or supervisor manages interaction in a Workbin.
 * In this sample the behavior consists in filled the "Owner Agent" attached data when an interation is put in a Workbin.
 */

public class WorkbinInterceptor {
    protected com.genesyslab.ail.Agent agent;
    protected InteractionMultimedia interactionMultimedia;
    protected Map attachedData;

    /**
     * This method is referenced as attribute "method" in corresponding interceptor.xml tag.
     * It is called automatically by the framework after all the "in" properties have been set
     * thanks to the set method declared above.
     */
    public void moveToWorkbinSupervisorAndPlaceInWorkbinAgent() {
    	try {
            interactionMultimedia.setAttachedData("Owner Agent", agent.getLastName() + " " + agent.getFirstName());
            interactionMultimedia.saveAttachedData();
        } catch(RequestFailedException e) {
            System.out.println("Save attached data aborted" + e);
            e.printStackTrace();
        }
    }

    /**
     * This method is referenced as attribute "method" in corresponding interceptor.xml tag.
     * It is called automatically by the framework after all the "in" properties have been set
     * thanks to the set method declared above.
     */
    public void moveToWorkbin() {
        attachedData.put("Owner Agent",agent.getLastName() + " " + agent.getFirstName());
    }

    /**
     * Called by interceptor framework prior to call to "moveToWorkbin" and "moveToWorkbinSupervisorAndPlaceInWorkbinAgent" methods.
     * This is a standard attribute.
     */
	public void setAgent(com.genesyslab.ail.Agent agent) {
		this.agent = agent;
	}

    /**
     * Called by interceptor framework prior to call "moveToWorkbinSupervisorAndPlaceInWorkbinAgent" method.
     * This is a standard attribute.
     */
	public void setInteractionMultimedia(InteractionMultimedia interactionMultimedia) {
		this.interactionMultimedia = interactionMultimedia;
	}

    /**
     * Called by interceptor framework after to call "moveToWorkbin" method.
     * This is a standard attribute.
     */
    public Map getAttachedData() {
        return this.attachedData;
    }

    /**
     * Called by interceptor framework prior to call "moveToWorkbin" method.
     * This is a standard attribute.
     */
    public void setAttachedData(Map attachedData) {
        this.attachedData = attachedData;
    }
}
